@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="{{ route('auberges.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf 
        <h3 class="mb-4 text-center"> استمارة اضافة مركب او مركز اقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الإسم <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input name="nom" type="text" class="form-control" required 
                    value="{{ old('nom') }}">
            </div>

            <label class="col-sm-2 col-form-label"> الصبغة </label>
            <div class="col-sm-4">
                <select name="epa" class="form-control" required>
                    <option value="">-- اختر الصبغة --</option>
                    <option value="EPA" {{ old('epa') == 'EPA' ? 'selected' : '' }}>EPA</option>
                    <option value="Non EPA" {{ old('epa') == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label for="description" class="col-sm-6 col-form-label"> تعريف المركز <span class="text-danger">*</span> </label>
            <textarea name="description" placeholder="" id="description" class="form-control" rows="4">{{ old('description') }}</textarea>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="latitude" class="form-control"
                    value="{{ old('latitude') }}"
                    placeholder="مثلاً: 36.8065">
            </div>

            <label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="longitude" class="form-control"
                    value="{{ old('longitude') }}"
                    placeholder="مثلاً: 10.1815">
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الوسط الذي توجد به المؤسسة </label>
            <div class="col-sm-4">
                <select name="id_milieu_auberge" class="form-control" required>
                    <option value="">-- اختر الوسط --</option>
                    @foreach($milieux as $milieu)
                        <option value="{{ $milieu->id_type }}">
                            {{ $milieu->type_ar }}
                        </option>
                    @endforeach
                </select>
            </div>

            <label class="col-sm-2 col-form-label"> الإحداثيات </label>
            <div class="col-sm-4">
                <input type="text" name="coordonnees" class="form-control" 
                    value="{{ old('coordonnees') }}">
            </div>
        </div> 
        
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> العنوان <span class="text-danger">*</span> </label>
            <div class="col-sm-4">
                <input type="text" name="adresse" class="form-control" 
                    value="{{ old('adresse') }}">
            </div>

            <label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="code_postal" class="form-control" 
                   value="{{ old('code_postal') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الولاية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                    <option value="" disabled selected>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}">{{ $gouv->nom_ar }}</option>
                        @endforeach
                </select>
            </div>
            
            <label class="col-sm-2 col-form-label"> المعتمدية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select required class="form-control" id="delegation_id" name="delegation_id" disabled>
                    <option value="" disabled selected>اختر...</option>
                </select>
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الهاتف القار <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="contact_tel" class="form-control" 
                    value="{{ old('contact_tel') }}">
            </div>

            <label class="col-sm-2 col-form-label"> الفاكس <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="fax" class="form-control" 
                   value="{{ old('fax') }}">
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> البريد الإلكتروني للمؤسسة <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="email" name="contact_email" class="form-control" 
                    value="{{ old('contact_email') }}">
            </div>

             <label class="col-sm-2 col-form-label"> صورة المركب<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="file" name="image" id="image" class="form-control" accept="image/*">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="prix_lit" class="form-control" 
                    value="{{ old('prix_lit') }}" step="0.01" min="0">
            </div>
        </div>

        <h4 class="mt-3"> مدير المؤسسة </h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="nom_directeur" class="form-control"
                    value="{{ old('nom_directeur') }}">
            </div>

            <label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="tel_directeur" class="form-control"
                    value="{{ old('tel_directeur') }}">
            </div>
        </div>


        <h4 class="mt-3"> الخدمات</h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ </label>
            <div class="col-sm-4">
                <select name="espace_boisson" id="espace_boisson" class="form-control" required>
                    <option value="" disabled selected>اختر...</option>
                    <option value="1" {{ old('espace_boisson') == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('espace_boisson') == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>

            <label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select name="piscine" class="form-control" required>
                    <option value="" disabled selected>اختر...</option>
                    <option value="1" {{ old('piscine') == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('piscine') == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">الفضاءات المتوفرة</label>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_tv_web" id="espace_tv_web" value="1">
                <label class="col-sm-4 col-form-label" for="espace_tv_web">
                    فضاء تلفزة واب
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_radio_web" id="espace_radio_web" value="1">
                <label class="col-sm-4 col-form-label" for="espace_radio_web">
                    فضاء راديو واب
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_gaming" id="espace_gaming" value="1">
                <label class="col-sm-4 col-form-label" for="espace_gaming">
                    فضاء ألعاب إلكترونية
                </label>
            </div>
        </div>


        


<div class="form-group row mt-4">
    <h5 class="text-center mb-3">الغرف</h5>

    <table id="chambres-table" class="custom-table">
        <thead>
            <tr>
                <th></th>
                <th>نوع الغرفة</th>
                <th>الطاقة</th>
                <th>رقم الغرفة</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="chambres-body">
            <tr>
                <td class="row-number">1</td>
                <td>
                    <select name="chambres[0][type_chambre_id]" class="form-control type-chambre" required>
                        <option value="">-- اختر النوع --</option>
                        @foreach($typesChambres as $t)
                        <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td><input type="number" name="chambres[0][capacite]" class="form-control nb-lits" required></td>
                <td><input type="text" name="chambres[0][num_chambre]" class="form-control" required></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
                </td>
            </tr>
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة جديدة</button>
</div>
<div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <!--input type="number" name="capacite_batiment" class="form-control" value="{{ old('capacite_batiment') }}"-->
                <input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" readonly>
            </div>

            <label class="col-sm-2 col-form-label">
                 عدد الغرف <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres" class="form-control" value="{{ old('nb_chambres') }}"-->
                <input type="number" name="nb_chambres" id="nb_chambres" class="form-control" readonly>

            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف الفردية</label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres_single" class="form-control" value="{{ old('nb_chambres_single') }}"-->
                <input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" readonly>

            </div>

            <label class="col-sm-2 col-form-label">
                 عدد الغرف ثنائي</label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres_double" class="form-control" value="{{ old('nb_chambres_double') }}"-->
                <input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" readonly>

            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف ثلاثي</label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres_triple" class="form-control" value="{{ old('nb_chambres_triple') }}"-->
                <input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" readonly>

            </div>

            <label class="col-sm-2 col-form-label">
                 عدد الغرف رباعي</label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres_quadra" class="form-control" value="{{ old('nb_chambres_quadra') }}"-->
                <input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" readonly>
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف أكثر من رباعي</label>
            <div class="col-sm-4">
                <!--input type="number" name="nb_chambres_plus" class="form-control" value="{{ old('nb_chambres_plus') }}"-->
                <input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" readonly>
            </div>

            <label class="col-sm-2 col-form-label">
                 عدد الوحدات الصحية داخل الغرف</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain" class="form-control" value="{{ old('nb_salles_de_bain') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" value="{{ old('nb_salles_de_bain_comm') }}">
            </div>
            <label class="col-sm-2 col-form-label">
               عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" value="{{ old('nb_chambres_tv') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
               عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" value="{{ old('nb_chambres_clim') }}">
            </div>
            <label class="col-sm-2 col-form-label">
               عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" value="{{ old('nb_chambres_frigo') }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
              طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" value="{{ old('capacite_tentes') }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled selected>اختر...</option>
                    <option value="1" {{ old('cuisine_fonctionnelle') == '1' ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('cuisine_fonctionnelle') == '0' ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-sm-2 col-form-label">الملاعب الرياضية</label>

            @foreach($sports as $sport)
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="sports[]" id="sport_{{ $sport->id_sport }}" value="{{ $sport->id_sport }}"
                        {{ in_array($sport->id_sport, old('sports', [])) ? 'checked' : '' }}>
                    <label class="col-sm-4 col-form-label" for="sport_{{ $sport->id_sport }}">
                        {{ $sport->nom_ar }} 
                    </label>
                </div>
            @endforeach
        </div>


        <div class="form-group mt-3">
            <label class="col-sm-6 col-form-label">الخدمات المقدمة من طرف المؤسسة</label>

            @foreach($services as $service)
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="services[]" id="service_{{ $service->id_service }}" value="{{ $service->id_service }}"
                        {{ in_array($service->id_service, old('services', [])) ? 'checked' : '' }}>
                    <label class="col-sm-2 col-form-label" for="service_{{ $service->id_service }}">
                        {{ $service->nom_ar }}
                    </label>
                </div>
            @endforeach
        </div>


        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>

    <table id="restauration-table" class="custom-table">
        <thead>
            <tr>
                <th>#</th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالإنجليزية</th>
                <th>الوصف بالعربية</th>
                <th>الوصف بالفرنسية</th>
                <th>الوصف بالإنجليزية</th>
                <th>التعريفة (د.ت)</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="restauration-body">
            <tr>
                <td class="row-number">1</td>

                <td><input type="text" name="restaurations[0][nom_ar]" class="form-control" required></td>
                <td><input type="text" name="restaurations[0][nom_fr]" class="form-control" required></td>
                <td><input type="text" name="restaurations[0][nom_en]" class="form-control" required></td>

                <td><textarea name="restaurations[0][description_ar]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[0][description_fr]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[0][description_en]" class="form-control" rows="1"></textarea></td>

                <td><input type="number" step="0.01" name="restaurations[0][tarif]" class="form-control" required></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                </td>
            </tr>
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
</div>


    <!-- ************************************* tableau d'ajout Restauration   ************************************************************ --> 


        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4">{{ old('lieux_culturels') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services') }}</textarea>
        </div>


        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>








<script>
    let chambreIndex = 1;
    function addChambreRow() {
        let tableBody = document.getElementById('chambres-body');

        let newRow = `
            <tr>
                <td class="row-number">${chambreIndex + 1}</td>

                <td>
                    <select name="chambres[${chambreIndex}][type_chambre_id]" class="form-control" required>
                        <option value="">-- اختر النوع --</option>
                        @foreach($typesChambres as $t)
                            <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                        @endforeach
                    </select>
                </td>

                <td><input type="number" name="chambres[${chambreIndex}][capacite]" class="form-control" required></td>
                <td><input type="text" name="chambres[${chambreIndex}][num_chambre]" class="form-control" required></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        chambreIndex++;
    }
    function removeChambreRow(button) {
        button.closest('tr').remove();
    }
</script>

<script>
document.getElementById('gouvernorat_id').addEventListener('change', function() {

    let gouvId = this.value;
    let delegationSelect = document.getElementById('delegation_id');

    delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';
    delegationSelect.disabled = true;

    let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
    url = url.replace("ID_PLACEHOLDER", gouvId);

    fetch(url)
        .then(response => response.json())
        .then(data => {

            delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

            data.forEach(d => {
                let option = document.createElement('option');
                option.value = d.id_delegation;
                option.text = d.nom_ar;
                delegationSelect.add(option);
            });

            delegationSelect.disabled = false;
        });
});
</script>


<script>
console.log("SCRIPT CHARGÉ !");  

function recalculer() {

    const rows = document.querySelectorAll('#chambres-body tr');

    let totalChambres = 0;
    let capaciteTotale = 0;

    let nb_single = 0, nb_double = 0, nb_triple = 0, nb_quadra = 0, nb_plus = 0;

    rows.forEach(row => {

        const typeEl = row.querySelector('.type-chambre');
        const litsEl = row.querySelector('.nb-lits');

        if (!typeEl || !litsEl) return;

        const type = typeEl.value;
        const lits = parseInt(litsEl.value || 0);

        totalChambres++;
        capaciteTotale += lits;

        switch (type) {
            case "1": nb_single++; break;
            case "2": nb_double++; break;
            case "3": nb_triple++; break;
            case "4": nb_quadra++; break;
            case "5": nb_plus++; break;
        }

    });

    document.getElementById('nb_chambres').value = totalChambres;
    document.getElementById('capacite_batiment').value = capaciteTotale;
    document.getElementById('nb_chambres_single').value = nb_single;
    document.getElementById('nb_chambres_double').value = nb_double;
    document.getElementById('nb_chambres_triple').value = nb_triple;
    document.getElementById('nb_chambres_quadra').value = nb_quadra;
    document.getElementById('nb_chambres_plus').value = nb_plus;
}

document.addEventListener('input', e => {
    if (e.target.classList.contains('type-chambre') || e.target.classList.contains('nb-lits')) {
        recalculer();
    }
});
document.addEventListener('change', e => {
    if (e.target.classList.contains('type-chambre')) {
        recalculer();
    }
});

function addChambreRow() {
    const tbody = document.getElementById('chambres-body');
    const index = tbody.querySelectorAll('tr').length;

    const tr = document.createElement('tr');

    tr.innerHTML = `
        <td class="row-number">${index + 1}</td>
        <td>
            <select name="chambres[${index}][type_chambre_id]" 
                    class="form-control type-chambre" required>
                <option value="">-- اختر النوع --</option>
                @foreach($typesChambres as $t)
                <option value="{{ $t->id_type }}">{{ $t->type_ar }}</option>
                @endforeach
            </select>
        </td>
        <td><input type="number" name="chambres[${index}][capacite]" class="form-control nb-lits" required></td>
        <td><input type="text" name="chambres[${index}][num_chambre]" class="form-control" required></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button></td>
    `;

    tbody.appendChild(tr);

    updateRowNumbers();
    recalculer();
}

function removeChambreRow(btn) {
    btn.closest('tr').remove();
    updateRowNumbers();
    recalculer();
}

function updateRowNumbers() {
    document.querySelectorAll('#chambres-body .row-number').forEach((cell, i) => {
        cell.textContent = i + 1;
    });
}

document.addEventListener('DOMContentLoaded', () => {
    updateRowNumbers();
    recalculer();
});
</script>


@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif